<?php
require 'config.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['teamId']) || !isset($data['caseId'])) {
    echo json_encode(['success' => false, 'error' => 'Eksik parametreler']);
    exit;
}

try {
    $pdo->beginTransaction();
    
    // Acil duruma ekip ata
    $stmt = $pdo->prepare("UPDATE `acil_durumlar` SET `assigned_team` = ?, `status` = 'assigned' WHERE `id` = ?");
    $stmt->execute([$data['teamId'], $data['caseId']]);
    
    // Ekibin durumunu güncelle
    $stmt = $pdo->prepare("UPDATE `ekipleri` SET `status` = 'assigned' WHERE `id` = ?");
    $stmt->execute([$data['teamId']]);
    
    $pdo->commit();
    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    $pdo->rollBack();
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>