<?php
session_start();

// Giriş bilgileri
define('ADMIN_USERNAME', 'yonetici');
define('ADMIN_PASSWORD', 'fL#9wBz@8Tg!');

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
        header("Location: yonetici.php");
        exit;
    } else {
        $error = "❌ Kullanıcı adı veya şifre hatalı!";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8" />
  <title>Yönetici Girişi - KARKUT</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap');

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
      font-family: 'Montserrat', sans-serif;
    }

    body {
      background: linear-gradient(135deg, #1f1c2c, #928dab);
      color: #eee;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      padding: 15px;
    }

    .container {
      background: rgba(255, 255, 255, 0.1);
      border-radius: 20px;
      padding: 40px 50px 50px;
      box-shadow:
        0 8px 32px 0 rgba(31, 38, 135, 0.37),
        0 0 20px rgba(255, 255, 255, 0.1);
      width: 100%;
      max-width: 400px;
      text-align: center;
      position: relative;
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      border: 1px solid rgba(255, 255, 255, 0.18);
      animation: fadeInUp 1s ease forwards;
    }

    @keyframes fadeInUp {
      0% {
        opacity: 0;
        transform: translateY(40px);
      }
      100% {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .logo-container {
      margin-bottom: 30px;
      animation: pulse 2s infinite;
    }

    @keyframes pulse {
      0%, 100% {
        transform: scale(1);
      }
      50% {
        transform: scale(1.08);
      }
    }

    .logo-container img {
      width: 110px;
      height: 110px;
      border-radius: 50%;
      border: 3px solid rgba(255,255,255,0.3);
      box-shadow: 0 0 15px rgba(255, 255, 255, 0.4);
      object-fit: contain;
      background: #fff;
      padding: 10px;
    }

    h2 {
      color: #ffd700;
      margin-bottom: 30px;
      font-weight: 700;
      letter-spacing: 1.5px;
      text-shadow: 0 0 8px #ffd700aa;
    }

    form {
      display: flex;
      flex-direction: column;
      gap: 20px;
    }

    .input-group {
      position: relative;
      width: 100%;
    }

    .input-group input {
      width: 100%;
      padding: 14px 45px 14px 15px;
      border: none;
      border-radius: 10px;
      background: rgba(255, 255, 255, 0.15);
      color: #fff;
      font-size: 16px;
      transition: background 0.3s ease;
      box-shadow: inset 0 0 8px rgba(255,255,255,0.1);
    }

    .input-group input::placeholder {
      color: #ddd;
      font-weight: 500;
    }

    .input-group input:focus {
      background: rgba(255, 255, 255, 0.3);
      outline: none;
      box-shadow: 0 0 10px 2px #ffd700;
      color: #fff;
    }

    /* İkonlar için basit svg kullanımı */
    .input-group svg {
      position: absolute;
      right: 15px;
      top: 50%;
      transform: translateY(-50%);
      fill: #ffd700;
      width: 22px;
      height: 22px;
      pointer-events: none;
      opacity: 0.7;
      transition: opacity 0.3s ease;
    }

    .input-group input:focus + svg {
      opacity: 1;
    }

    button {
      padding: 14px;
      border: none;
      border-radius: 12px;
      background: linear-gradient(45deg, #ffd700, #ff8c00);
      color: #222;
      font-weight: 700;
      font-size: 18px;
      cursor: pointer;
      box-shadow: 0 4px 15px #ffb600cc;
      transition: background 0.4s ease, box-shadow 0.4s ease;
      user-select: none;
    }

    button:hover {
      background: linear-gradient(45deg, #ffda44, #ffa300);
      box-shadow: 0 6px 25px #ffb600ee;
    }

    .error {
      margin-top: 10px;
      background: #ff4d4d;
      color: white;
      padding: 12px 15px;
      border-radius: 10px;
      font-weight: 600;
      animation: shake 0.5s;
      box-shadow: 0 0 8px #ff4d4dcc;
    }

    @keyframes shake {
      0%, 100% { transform: translateX(0); }
      20%, 60% { transform: translateX(-10px); }
      40%, 80% { transform: translateX(10px); }
    }

    @media (max-width: 480px) {
      .container {
        padding: 30px 25px 35px;
      }

      h2 {
        font-size: 22px;
      }

      button {
        font-size: 16px;
        padding: 12px;
      }
    }
  </style>
</head>
<body>

  <div class="container" role="main" aria-label="Yönetici Giriş Formu">
    <div class="logo-container" aria-hidden="true">
      <img src="image/karkut.png" alt="KARKUT Logo" />
    </div>

    <h2>Yönetici Paneli Girişi</h2>

    <form method="POST" novalidate autocomplete="off">
      <div class="input-group">
        <input
          type="text"
          name="username"
          placeholder="Kullanıcı Adı"
          required
          aria-label="Kullanıcı Adı"
          autocomplete="username"
        />
        <svg viewBox="0 0 24 24" aria-hidden="true">
          <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4
          v2h16v-2c0-2.66-5.33-4-8-4z" />
        </svg>
      </div>

      <div class="input-group">
        <input
          type="password"
          name="password"
          placeholder="Şifre"
          required
          aria-label="Şifre"
          autocomplete="current-password"
        />
        <svg viewBox="0 0 24 24" aria-hidden="true">
          <path d="M12 17a2 2 0 100-4 2 2 0 000 4zm6-8h-1V7a5 5 0 00-10 0v2H6a2 2 0 00-2 2v7a2 2 0 002
          2h12a2 2 0 002-2v-7a2 2 0 00-2-2zM8 7a4 4 0 018 0v2H8V7z" />
        </svg>
      </div>

      <button type="submit" aria-label="Giriş Yap">Giriş Yap</button>

      <?php if ($error): ?>
        <div class="error" role="alert" aria-live="assertive"><?= htmlspecialchars($error) ?></div>
      <?php endif; ?>
    </form>
  </div>

</body>
</html>
