// saveId.js
// KARKUT Deprem Bilgi Sistemi için deprem ID’lerini saklar ve günceller

// LocalStorage anahtarı
const STORAGE_KEY = "karkutQuakeIDs";

// ID listesini getir veya boş liste oluştur
function getSavedIDs() {
    const saved = localStorage.getItem(STORAGE_KEY);
        return saved ? JSON.parse(saved) : [];
        }

        // Yeni ID ekle
        function addQuakeID(id) {
            const ids = getSavedIDs();
                if (!ids.includes(id)) {
                        ids.push(id);
                                localStorage.setItem(STORAGE_KEY, JSON.stringify(ids));
                                        console.log(`Yeni deprem ID kaydedildi: ${id}`);
                                            }
                                            }

                                            // ID listesini temizle (opsiyonel)
                                            function clearSavedIDs() {
                                                localStorage.removeItem(STORAGE_KEY);
                                                    console.log("Deprem ID listesi temizlendi.");
                                                    }

                                                    // Örnek kullanım:
                                                    // addQuakeID("KARKUT-ABCDE");
                                                    // console.log(getSavedIDs());