<?php
// save_location.php
header('Content-Type: application/json');
require 'config.php';

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['latitude']) && isset($data['longitude'])) {
    $lat = floatval($data['latitude']);
    $lng = floatval($data['longitude']);
    $ip = $_SERVER['REMOTE_ADDR'];
    $emergencyType = isset($data['emergency_type']) ? $data['emergency_type'] : 'digery';
    $name = isset($data['name']) ? trim($data['name']) : '';
    $surname = isset($data['surname']) ? trim($data['surname']) : '';
    $phone = isset($data['phone']) ? trim($data['phone']) : '';

    // Geçerli acil durum türlerini kontrol et
    $validTypes = ['deprem', 'sel', 'yangin', 'bina_yikilmasi', 'trafik_kazasi', 'medikal'];
    if (!in_array($emergencyType, $validTypes)) {
        $emergencyType = 'digery';
    }

    // Telefon numarası temizleme (sadece rakamlar kalacak şekilde)
    $phone = preg_replace('/[^0-9]/', '', $phone);

    // Veritabanına ekleme
    $stmt = $pdo->prepare("INSERT INTO acil_durumlar 
        (latitude, longitude, emergency_type, name, surname, phone, ip) 
        VALUES (?, ?, ?, ?, ?, ?, ?)");
    
    if ($stmt->execute([$lat, $lng, $emergencyType, $name, $surname, $phone, $ip])) {
        echo json_encode([
            'success' => true, 
            'message' => 'Tüm bilgiler başarıyla kaydedildi',
            'data' => [
                'type' => $emergencyType,
                'name' => $name,
                'surname' => $surname,
                'phone' => $phone
            ]
        ]);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => 'Veritabanı kayıt hatası',
            'error' => $stmt->errorInfo()
        ]);
    }
} else {
    echo json_encode([
        'success' => false, 
        'message' => 'Eksik parametre: Konum bilgileri gereklidir',
        'received_data' => $data
    ]);
}
?>